/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.MyInputStream;
import cds.allsky.Action;
import cds.allsky.BuilderRunner;
import cds.allsky.Context;
import cds.allsky.ThreadBuilderTile;
import cds.fits.Fits;
import cds.tools.pixtools.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public class BuilderGzip
extends BuilderRunner {
    public int nbFile = 0;
    private Fits bidon;
    protected boolean compress;

    public BuilderGzip(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.GZIP;
    }

    @Override
    public void validateContext() throws Exception {
        this.validateOutput();
        if (!this.context.isExistingAllskyDir()) {
            throw new Exception("No Fits tile found");
        }
        this.validateOrder(this.context.getOutputPath());
        this.validateDepth();
        try {
            this.context.loadMoc();
        }
        catch (Exception e) {
            this.context.warning("Tile MOC not found => use index MOC");
        }
        if (!this.context.hasFrame()) {
            this.context.setFrameName(this.getFrame());
        }
        this.context.initRegion();
    }

    @Override
    public boolean isAlreadyDone() {
        if (!this.context.actionPrecedeAction(Action.INDEX, Action.TILES)) {
            return false;
        }
        if (!this.context.actionPrecedeAction(Action.TILES, Action.GZIP)) {
            return false;
        }
        if (this.context.actionAlreadyDone(Action.GUNZIP) && !this.context.actionPrecedeAction(Action.GZIP, Action.GUNZIP)) {
            return false;
        }
        this.context.info("GZIP seems to be already done");
        return true;
    }

    @Override
    public void run() throws Exception {
        this.build();
    }

    @Override
    public void build() throws Exception {
        this.ordermax = this.context.getOrder();
        this.context.resetCheckCode("fits");
        super.build();
        this.context.info((Object)((Object)this.getAction()) + " allsky...");
        this.allsky(this.context.getOutputPath());
    }

    @Override
    public void buildPre() {
        this.bidon = new Fits();
        this.compress = true;
    }

    @Override
    protected Fits createLeafHpx(ThreadBuilderTile hpx, String file, String path, int order, long npix, int z) throws Exception {
        String filename = Util.getFilePath(path, order, npix, z) + ".fits";
        long duree = this.gzip(filename);
        this.updateStat(0, 1, 0, duree, 0, 0L);
        ++this.nbFile;
        return this.bidon;
    }

    @Override
    protected Fits createNodeHpx(String file, String path, int order, long npix, Fits[] fils, int z) throws Exception {
        String filename = Util.getFilePath(path, order, npix, z) + ".fits";
        long duree = this.gzip(filename);
        this.updateStat(0, 0, 0, 0L, 1, duree);
        ++this.nbFile;
        return this.bidon;
    }

    private void allsky(String path) throws Exception {
        for (int z = 0; z < this.context.depth; ++z) {
            String allsky = path + FS + "Norder3" + FS + "Allsky" + (z == 0 ? "" : "_" + z) + ".fits";
            if (!new File(allsky).isFile()) continue;
            this.gzip(allsky, this.compress);
            ++this.nbFile;
        }
    }

    protected long gzip(String filename) throws Exception {
        if (!new File(filename).isFile()) {
            return 0L;
        }
        long t = System.currentTimeMillis();
        this.gzip(filename, this.compress);
        return System.currentTimeMillis() - t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gzip(String file, boolean compress) throws Exception {
        MyInputStream mis = null;
        OutputStream mos = null;
        OutputStream fos = null;
        try {
            int n;
            String outFile;
            File out;
            File in = new File(file);
            if (!in.isFile()) {
                throw new Exception(file + " does not exist !");
            }
            mis = new MyInputStream(new FileInputStream(in));
            if (compress) {
                if (mis.isGZ()) {
                    return;
                }
            } else {
                if (!mis.isGZ()) {
                    return;
                }
                mis = mis.startRead();
            }
            if ((out = new File(outFile = file + ".tmp")).isFile()) {
                out.delete();
            }
            fos = new FileOutputStream(outFile);
            mos = compress ? new GZIPOutputStream(fos) : fos;
            byte[] buf = new byte[8192];
            while ((n = mis.read(buf)) >= 0) {
                mos.write(buf, 0, n);
                if (!this.context.isTaskAborting()) continue;
            }
            mis.close();
            mis = null;
            mos.close();
            mos = null;
            fos = null;
            if (this.context.isTaskAborting()) {
                out.delete();
            } else {
                in.delete();
                in = new File(file);
                if (!out.renameTo(in)) {
                    throw new Exception("Cannot rename " + outFile + " in " + file);
                }
                ++this.nbFile;
                if (this.context != null) {
                    this.context.setProgress(this.nbFile);
                }
            }
        }
        finally {
            if (mis != null) {
                mis.close();
            }
            if (mos != null) {
                mos.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
        if (this.context.isTaskAborting()) {
            throw new Exception("Task abort !");
        }
    }
}

